import { Component, OnInit } from '@angular/core';
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { Product } from '../../core/maincontent/product'
import { ActiveState } from '../../core/activestate/activestate.service'

@Component({
  selector: 'app-einsurance-home',
  templateUrl: './einsurance-home.component.html',
  styleUrls: ['./einsurance-home.component.css']
})
export class EinsuranceHomeComponent implements OnInit {
  maincontentService: MainContentService
  product: Product

  constructor(public activeState: ActiveState,
              private mcService: MainContentService) {
    this.maincontentService = mcService

  }

  ngOnInit() {
    this.maincontentService.getProduct('einsurance').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
